//AIM:Compute the numerical aperture & the acceptance angle for the fiber in air
//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Let the velocity of light in vacuum be 2.998*10^8 m/sec,critical angle at the
// core-cladding interface be 80 degrees & velocity of light in the core 
//of a step index fiber be 2.01*10^8 m/sec

c=2.998*10^8;//c=velocity of light in vacuum
v1=2.01*10^8;//v1=velocity of light in the core
theta_c=80*(%pi/180);//Expressing theta_c in radians
n1=c/v1;
disp(n1,'n1=')
//Since sin(theta_c)=n2/n1
n2=sin(theta_c)*n1;
disp(n2,'n2=')
NA=sqrt((n1^2)-(n2^2))
disp(NA,'Numerical aperture (NA)=')
//Computing the acceptance angle
theta_a=asin(NA)
theta_a_degrees=(theta_a)*(180/%pi);
disp('degrees',theta_a_degrees,'Acceptance angle (theta_a)=')
